// IGCAPI.h : header file
//
// Copyright (c) 2000-2001 Marc Ramsey. All rights reserved.
//
// http://www.ranlog.com/ramsey/
//
// This software is provided as is with no warranties of any kind, 
// including the warranties of design, merchantibility and fitness 
// for a particular purpose, noninfringement, or arising from a 
// course of dealing, usage or trade practice.  This software is 
// provided with no support and without any obligation to assist in 
// its use, correction, modification, or enhancement.
//
// Permission to use, copy, or modify this software for any purpose 
// is hereby granted without fee, provided the above notices are 
// retained on all copies of the source code. 

#ifndef IGCAPI_H
#define IGCAPI_H

#ifndef IGCAPIDLL
#define IGC_API
#elif defined(IGCAPIDLL_EXPORT)
#define IGC_API __declspec(dllexport)
#else
#define IGC_API __declspec(dllimport)
#endif

// IdentifyDLL fields
typedef enum {
	IDDLL_CODE,
	IDDLL_MANUFACTURER,
	IDDLL_MODEL,
	IDDLL_REVISION,
	IDDLL_CONVERT_EXT,
	IDDLL_VALIDATE_EXT
} IdDLLField;

// IdentifyLogFR fields
typedef enum {
	IDLOG_FILENAME,
	IDLOG_DATE,
	IDLOG_START,
	IDLOG_END,
	IDLOG_PILOT,
	IDLOG_ID,
	IDLOG_CLASS
} IdLogField;

#if defined(__cplusplus)
extern "C"
{
#endif

VOID IGC_API ErrorBox(LPCTSTR message);
VOID IGC_API LastErrorBox(LPCTSTR arg, ...);
DWORD IGC_API IdentifyDLLField(IdDLLField field, LPTSTR string, DWORD size);
DWORD IGC_API IdentifyDLLExt(IdDLLField field, LPTSTR string, DWORD size);
LPVOID IGC_API LoadDLL(LPCTSTR filename);
VOID IGC_API UnloadDLL(LPVOID igcdll);
DWORD IGC_API LoadAllDLLs(LPCTSTR directory);
BOOL IGC_API SelectDLL(DWORD index);
VOID IGC_API UnloadAllDLLs();
DWORD IGC_API IdentifyDLL(LPTSTR value, DWORD size);
HICON IGC_API LoadIconDLL();
VOID IGC_API InitializeDLL(HWND windowHandle, BOOL quietMode);
VOID IGC_API SetWindowDLL(HWND windowHandle);
DWORD IGC_API KeepAwakeIntervalDLL();
BOOL  IGC_API UseSerialOptionsDLL();
DWORD IGC_API SerialOptionsDLL(LPTSTR options, DWORD size);
BOOL IGC_API SerialConnectFR(LPCTSTR device, LPCTSTR options);
BOOL IGC_API KeepAwakeFR();
DWORD IGC_API IdentifyFR(LPTSTR value, DWORD size);
DWORD IGC_API IdentifyLogFR(DWORD index, LPTSTR value, DWORD size);
BOOL IGC_API DownloadLogFR(DWORD index, LPCTSTR filename);
VOID IGC_API DisconnectFR();
BOOL  IGC_API UseConvertLog();
BOOL IGC_API ConvertLog(LPCTSTR filename, LPCTSTR igcFilename);
BOOL IGC_API ValidateLog(LPCTSTR filename);

#if defined(__cplusplus)
}
#endif 

#endif // IGCAPI_H
